Drupal.WeMegaMenuFrontEnd = Drupal.WeMegaMenuFrontEnd || {};
Drupal.WeMegaMenuFrontEnd.mobileThreadHold = 1024;
Drupal.WeMegaMenuFrontEnd.megamenuActivated = false;

(function ($, Drupal, drupalSettings) {
  "use strict";

  Drupal.behaviors.kMegaMenuFrontEndAction = {
    attach: function (context) {
      $(window).on('load', function() {
        Drupal.WeMegaMenuFrontEnd.init();
        Drupal.WeMegaMenuFrontEnd.mobileMenu();
      })
    }
  };

  Drupal.WeMegaMenuFrontEnd.init = function() {
    if(Drupal.WeMegaMenuFrontEnd.megamenuActivated) {
      return;
    }
    Drupal.WeMegaMenuFrontEnd.megamenuActivated = true;
  	var megamenu = $('nav.navbar-we-mega-menu');
  	if(megamenu.hasClass('click-action')) {
  	  megamenu.find('ul li.dropdown-menu > a').click(function() {
  	  	var li = $(this).closest("li");

  	  	if(li.hasClass("clicked")) {
          li.closest('ul').find('li').removeClass('clicked');
          li.closest('.we-mega-menu-row').find('li').removeClass('clicked');
  	  	  li.removeClass("clicked");
          megamenu.removeClass("has-clicked");
  	  	} else {
          li.closest('ul').find('li').removeClass('clicked');
          li.closest('.we-mega-menu-row').find('li').removeClass('clicked');
	  	    li.closest("ul").children("li.dropdown-menu").removeClass("clicked");
  		    li.addClass("clicked");
          megamenu.addClass("has-clicked");
  	  	}
        if($(window).outerWidth() > Drupal.WeMegaMenuFrontEnd.mobileThreadHold) {
          return false;
        }
  	  });
  	  megamenu.find('ul li.dropdown-menu > a').dblclick(function() {
        if($(window).outerWidth() > Drupal.WeMegaMenuFrontEnd.mobileThreadHold) {
    	  	window.location.href = $(this).attr("href");
        }
  	  });
      megamenu.click(function(event) {
        event.stopPropagation();
      })
      $("body").click(function() {
        megamenu.find("ul li.dropdown-menu.clicked").removeClass('clicked');
        megamenu.removeClass("has-clicked");
      });
  	}
  };

  Drupal.WeMegaMenuFrontEnd.mobileMenu = function() {
    $('div.region-we-mega-menu a.navbar-toggle').mobileMenu();
    
    // $('div.region-we-mega-menu a.navbar-toggle').mobileMenu({
      // pageSelector: 'body',
      // targetWrapper: '.navbar-we-mega-menu'
    // });

    // $('#menu-toggle-wemegamenu').mobileMenu();
  };
})(jQuery, Drupal, drupalSettings);