Contributing to jCarousel
=========================


Reporting issues
----------------

Please read the following guidelines before opening any
[issue](https://github.com/jsor/jcarousel/issues):

1. **Search for existing issues.** Maybe someone else has reported the same
   issue and it may have already been resolved with a fix available.
2. **Create an isolated and reproducible test case.** When you are experiencing
   a problem, the most useful thing you can do is to provide a
   [reduced test case](http://css-tricks.com/reduced-test-cases/). This makes it
   much easier to isolate and fix the offending code. Bugs that are reported
   without reduced test cases generally take much longer to fix than bugs that
   are submitted with them, so you really should try to do this if at all
   possible.
3. **Include a live example.** Make use of [JSFiddle](http://jsfiddle.net) or
   [Codepen](http://codepen.io) to share your isolated test cases.


Pull requests
-------------

Pull requests are always welcome. But please note that i'm trying to keep the
jCarousel core as small as possible. Before adding new features, it's probably a
good idea to open an issue first and discuss it.

Pull request guidelines:

- Follow the coding style used in jCarousel.
- Keep your patches small and simple.
- Use a topic branch and open the pull request against the `master` branch.
